﻿$(document).ready(function () {
    _paq.push(['trackEvent', 'Survey-Edit-WordImport', 'Open Word Import']);
    resizeWordImport();

    $(".button-save").on("click", function () {
        var wordImportFrame = $("#WordImportFrame")[0];
        wordImportFrame.contentWindow.postMessage("ImportQuestions", wordImportFrame.src);
    });

    $(window).on("message", function (event) {
        var wordImportFrameSrc = $("#WordImportFrame")[0].src;
        var eventOrigin = event.originalEvent.origin;
        var originatesFromWordImportFrame = wordImportFrameSrc.indexOf(eventOrigin) == 0

        if (originatesFromWordImportFrame) {
            if (event.originalEvent.data == "ShowBusyBox") {
                a4.showBusyBox();
            }
            else if (event.originalEvent.data == "DisableTopButtons") {
                $(".button-cancel").prop("disabled", true).addClass("disabled");
                $(".button-save").prop("disabled", true);
            }
            else if (event.originalEvent.data == "EnableTopButtons") {
                $(".button-cancel").prop("disabled", false).removeClass("disabled");
                $(".button-save").prop("disabled", false);
            }
            else {
                a4.hideBusyBox();

                if (event.originalEvent.data == "RedirectToQuestionnaireEditor") {
                    window.location.href = a4.getSurveyAction("Edit", "Questionnaire");
                }
                else if (event.originalEvent.data.errorMessage) {
                    a4.showErrorMessage(event.originalEvent.data.errorMessage);
                }
            }
        }
    });
});

$(window).on("resize", function () {
    resizeWordImport();
});